/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.kawakubo;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author tomoharu
 */
public class ImoshochuCatalogServlet extends HttpServlet {
   
    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request,
                                    HttpServletResponse response)
    throws ServletException, IOException {
        // DAOクラスをインスタンス化する
        ImoshochuCatalogDAO imoshochuCatalogDAO = new ImoshochuCatalogDAOImpl();
        // requestからHttpSessionを取り出し、ImoshochuCatalogItemのArrayList
        //　を"imoCatalog"として埋め込む
        request.getSession().setAttribute("imoCatalog",
                                imoshochuCatalogDAO.getImoshochuCatalogList());
        // 第7回で追加
        String userId = request.getUserPrincipal().getName();
        BasketHelper basketHelper = new BasketHelper();

        int basketId = 0;
        ArrayList<BasketItem> basketItems = new ArrayList<BasketItem>();
        // 第7回で「tomoharu」からログイン画面のパラメタj_usernameから取得するよう変更
        basketId = basketHelper.getBasketId(userId);
        basketItems = basketHelper.getBasketItems(basketId);
        request.getSession().setAttribute("basket", basketItems);
        // 第6回で追加
        ArrayList totalCharge = basketHelper.getTotalCharge(basketItems);
        request.getSession().setAttribute("totalCharge", totalCharge);

        // ImoshochuShop.jspに遷移する
        RequestDispatcher rd = request.getRequestDispatcher("/ImoshochuShop.jsp");
        rd.forward(request, response);

    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "芋焼酎酒店";
    }// </editor-fold>

}
